package cc.smarnet.tscdemo;

import androidx.appcompat.app.AppCompatActivity;
import androidx.core.app.ActivityCompat;
import androidx.core.content.ContextCompat;

import android.Manifest;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.PackageManager;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Color;
import android.hardware.usb.UsbDevice;
import android.hardware.usb.UsbManager;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import android.widget.TextView;
import android.widget.Toast;

import com.smart.command.CpclCommand;
import com.smart.command.EscCommand;
import com.smart.command.LabelCommand;
import com.smart.io.WriterResult;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Vector;

import static android.hardware.usb.UsbManager.ACTION_USB_DEVICE_ATTACHED;
import static android.hardware.usb.UsbManager.ACTION_USB_DEVICE_DETACHED;
import static cc.smarnet.tscdemo.DeviceConnFactoryManager.ACTION_QUERY_PRINTER_STATE;
import static cc.smarnet.tscdemo.DeviceConnFactoryManager.CONN_STATE_FAILED;

public class MainActivity extends AppCompatActivity {
    private static final String TAG = "MainActivity";
    ArrayList<String> per = new ArrayList<>();
    private UsbManager usbManager;
    private int counts;
    private static final int REQUEST_CODE = 0x004;

    private Bitmap bitmap = Bitmap.createBitmap(660, 40, Bitmap.Config.ARGB_8888);

    /**
     * Connection status disconnected
     */
    private static final int CONN_STATE_DISCONN = 0x007;
    /**
     * Use printer command error
     */
    private static final int PRINTER_COMMAND_ERROR = 0x008;

    private static final int CONN_MOST_DEVICES = 0x11;
    private static final int CONN_PRINTER = 0x12;
    private PendingIntent mPermissionIntent;
    private String[] permissions = {
            Manifest.permission.ACCESS_FINE_LOCATION,
            Manifest.permission.ACCESS_COARSE_LOCATION,
            Manifest.permission.BLUETOOTH
    };
    private String usbName;
    private TextView tvConnState;
    private ThreadPool threadPool;

    private int id = 0;
    private int printcount = 0;
    private boolean continuityprint = false;

    // private KeepConn keepConn;
    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Log.e(TAG, "onCreate()");
        setContentView(R.layout.activity_main);
        usbManager = (UsbManager) getSystemService(Context.USB_SERVICE);
        checkPermission();
        requestPermission();
        tvConnState = (TextView) findViewById(R.id.tv_connState);
    }

    @Override
    protected void onStart() {
        super.onStart();
        IntentFilter filter = new IntentFilter();
        filter.addAction(ACTION_QUERY_PRINTER_STATE);
        filter.addAction(DeviceConnFactoryManager.ACTION_CONN_STATE);
        registerReceiver(receiver, filter);
    }

    private void checkPermission() {
        for (String permission : permissions) {
            if (PackageManager.PERMISSION_GRANTED != ContextCompat.checkSelfPermission(this, permission)) {
                per.add(permission);
            }
        }
    }

    private void requestPermission() {
        if (per.size() > 0) {
            String[] p = new String[per.size()];
            ActivityCompat.requestPermissions(this, per.toArray(p), REQUEST_CODE);
        }
    }

    /**
     * Bluetooth connect
     */
    public void btnBluetoothConn(View view) {
        startActivityForResult(new Intent(this, BluetoothDeviceList.class), Constant.BLUETOOTH_REQUEST_CODE);
    }

    public void btnWifiConn(View view) {
        WifiParameterConfigDialog wifiParameterConfigDialog = new WifiParameterConfigDialog(this, new WifiParameterConfigDialog.WifiConfigCallback() {
            @Override
            public void callback(String ip, int port) {
                new DeviceConnFactoryManager.Build()
                        //Set bluetooth mac address
                        .setConnectMethod(DeviceConnFactoryManager.CONN_METHOD.WIFI)
                        .setIp(ip)
                        .setPort(port)
                        .build();
                //Open port
                threadPool = ThreadPool.getInstantiation();
                threadPool.addTask(() -> DeviceConnFactoryManager.getDeviceConnFactoryManager().openPort());
            }
        });
        wifiParameterConfigDialog.show();
    }

    /**
     * Print label
     */
    public void btnLabelPrint(View view) {
        threadPool = ThreadPool.getInstantiation();
        threadPool.addTask(() -> {
            if (!isConnected()) {
                mHandler.obtainMessage(CONN_PRINTER).sendToTarget();
                return;
            }
            sendLabel();
        });
    }

    public void btnLabelOrder(View view) {
        threadPool = ThreadPool.getInstantiation();
        threadPool.addTask(() -> {
            if (!isConnected()) {
                mHandler.obtainMessage(CONN_PRINTER).sendToTarget();
                return;
            }
            sendLabelOrder();
        });
    }

    private void sendLabelOrder() {
        LabelCommand command = new LabelCommand();
        command.addSize(75 ,128);
    command.addDirection(LabelCommand.DIRECTION.BACKWARD, LabelCommand.MIRROR.NORMAL);
    command.addReference(0,0);
    command.addPeel(EscCommand.ENABLE.OFF);
    command.addTear(EscCommand.ENABLE.OFF);
    command.addCodePage(LabelCommand.CODEPAGE.PC437);
    command.addCls();
    command.addBar(0 ,120 ,600 ,2);
    command.addBar(0 ,240 ,600 ,2);
    command.addBar(0 ,400 ,600 ,2);
    command.addBar(0 ,560 ,600 ,2);
    command.addBar(0 ,640 ,600 ,2);
    command.addBar(0 ,720 ,600 ,2);
    command.addBar(0 ,816 ,600 ,2);
    command.addBar(0 ,848 ,600 ,2);
    command.addBar(0 ,888 ,600 ,2);
    command.addBar(40 ,400 ,2 ,240);
    command.addBar(160 ,640 ,2 ,80);
    command.addBar(360 ,640 ,2 ,80);
    command.addBar(40 ,720 ,2 ,96);
    command.addBox(456 ,904 ,560 ,944 ,2);
    command.addText(16,96, LabelCommand.FONTTYPE.SIMPLIFIED_CHINESE, LabelCommand.ROTATION.ROTATION_0, LabelCommand.FONTMUL.MUL_1, LabelCommand.FONTMUL.MUL_1,"*第93次打印：20-10-06 11:49");

    command.addText(200,48, LabelCommand.FONTTYPE.SIMPLIFIED_CHINESE_32, LabelCommand.ROTATION.ROTATION_0, LabelCommand.FONTMUL.MUL_1, LabelCommand.FONTMUL.MUL_1,"到付:10元");

    command.addText(80,152, LabelCommand.FONTTYPE.SIMPLIFIED_CHINESE_32, LabelCommand.ROTATION.ROTATION_0, LabelCommand.FONTMUL.MUL_2, LabelCommand.FONTMUL.MUL_2,"574-402-00-001");


    command.addText(160,368, LabelCommand.FONTTYPE.SIMPLIFIED_CHINESE_32, LabelCommand.ROTATION.ROTATION_0, LabelCommand.FONTMUL.MUL_1, LabelCommand.FONTMUL.MUL_1,"DD23 2860 9493 ");

        command.addText(0, 464, LabelCommand.FONTTYPE.SIMPLIFIED_CHINESE_32, LabelCommand.ROTATION.ROTATION_0, LabelCommand.FONTMUL.MUL_1, LabelCommand.FONTMUL.MUL_1, "收");

        command.addText(56, 424, LabelCommand.FONTTYPE.SIMPLIFIED_CHINESE_32,
                LabelCommand.ROTATION.ROTATION_0, LabelCommand.FONTMUL.MUL_1, LabelCommand.FONTMUL.MUL_1, "张盼盼 15088965523");

        command.addText(56,464, LabelCommand.FONTTYPE.SIMPLIFIED_CHINESE, LabelCommand.ROTATION.ROTATION_0, LabelCommand.FONTMUL.MUL_1, LabelCommand.FONTMUL.MUL_1,
                "福建省厦门市湖里区厦门市湖里区高崎南");

        command.addText(56,494, LabelCommand.FONTTYPE.SIMPLIFIED_CHINESE, LabelCommand.ROTATION.ROTATION_0, LabelCommand.FONTMUL.MUL_1,
                LabelCommand.FONTMUL.MUL_1,"十二路2-10号");

        command.addText(0, 588, LabelCommand.FONTTYPE.SIMPLIFIED_CHINESE_32, LabelCommand.ROTATION.ROTATION_0, LabelCommand.FONTMUL.MUL_1,
                LabelCommand.FONTMUL.MUL_1, "寄");

        command.addText(56,576, LabelCommand.FONTTYPE.SIMPLIFIED_CHINESE, LabelCommand.ROTATION.ROTATION_0, LabelCommand.FONTMUL.MUL_1,
                LabelCommand.FONTMUL.MUL_1,"邵娟 15060759932");


        command.addText(56,608, LabelCommand.FONTTYPE.SIMPLIFIED_CHINESE, LabelCommand.ROTATION.ROTATION_0, LabelCommand.FONTMUL.MUL_1, LabelCommand.FONTMUL.MUL_1,
                "福建省厦门市湖里区福建省厦门市湖里区高崎南十二路8艾德航空工业园8号楼4-5层");

        command.addText(32, 648, LabelCommand.FONTTYPE.SIMPLIFIED_CHINESE_32, LabelCommand.ROTATION.ROTATION_0, LabelCommand.FONTMUL.MUL_1, LabelCommand.FONTMUL.MUL_1,
                "402");

        command.addText(368,656, LabelCommand.FONTTYPE.SIMPLIFIED_CHINESE, LabelCommand.ROTATION.ROTATION_0, LabelCommand.FONTMUL.MUL_1,
                LabelCommand.FONTMUL.MUL_1,"签收人");

        command.addText(368, 688, LabelCommand.FONTTYPE.SIMPLIFIED_CHINESE, LabelCommand.ROTATION.ROTATION_0, LabelCommand.FONTMUL.MUL_1,
                LabelCommand.FONTMUL.MUL_1, "日期");

        command.addText(8,752, LabelCommand.FONTTYPE.SIMPLIFIED_CHINESE, LabelCommand.ROTATION.ROTATION_0, LabelCommand.FONTMUL.MUL_1,
                LabelCommand.FONTMUL.MUL_1,"服");

        command.addText(8,778, LabelCommand.FONTTYPE.SIMPLIFIED_CHINESE, LabelCommand.ROTATION.ROTATION_0, LabelCommand.FONTMUL.MUL_1,
                LabelCommand.FONTMUL.MUL_1,"务");

        command.addText(56,728, LabelCommand.FONTTYPE.SIMPLIFIED_CHINESE, LabelCommand.ROTATION.ROTATION_0, LabelCommand.FONTMUL.MUL_1,
                LabelCommand.FONTMUL.MUL_1,"寄件码: null");

    command.addText(336,728, LabelCommand.FONTTYPE.SIMPLIFIED_CHINESE, LabelCommand.ROTATION.ROTATION_0, LabelCommand.FONTMUL.MUL_1,
            LabelCommand.FONTMUL.MUL_1,"运费: 10.00元");

    command.addText(56,760, LabelCommand.FONTTYPE.SIMPLIFIED_CHINESE, LabelCommand.ROTATION.ROTATION_0, LabelCommand.FONTMUL.MUL_1,
            LabelCommand.FONTMUL.MUL_1,"取件员: 时明明");

    command.addText(336,760, LabelCommand.FONTTYPE.SIMPLIFIED_CHINESE, LabelCommand.ROTATION.ROTATION_0, LabelCommand.FONTMUL.MUL_1,
            LabelCommand.FONTMUL.MUL_1,"运输方式: ");

    command.addText(56,792, LabelCommand.FONTTYPE.SIMPLIFIED_CHINESE, LabelCommand.ROTATION.ROTATION_0, LabelCommand.FONTMUL.MUL_1,
            LabelCommand.FONTMUL.MUL_1,"数量: 1");

    command.addText(336,792, LabelCommand.FONTTYPE.SIMPLIFIED_CHINESE, LabelCommand.ROTATION.ROTATION_0, LabelCommand.FONTMUL.MUL_1,
            LabelCommand.FONTMUL.MUL_1,"重量:1 KG");

    command.addText(8,820, LabelCommand.FONTTYPE.SIMPLIFIED_CHINESE, LabelCommand.ROTATION.ROTATION_0, LabelCommand.FONTMUL.MUL_1,
            LabelCommand.FONTMUL.MUL_1,"品名:茶叶");

        command.addText(8, 860, LabelCommand.FONTTYPE.SIMPLIFIED_CHINESE, LabelCommand.ROTATION.ROTATION_0, LabelCommand.FONTMUL.MUL_1,
                LabelCommand.FONTMUL.MUL_1, "备注");

        command.addText(464,912, LabelCommand.FONTTYPE.SIMPLIFIED_CHINESE_32, LabelCommand.ROTATION.ROTATION_0, LabelCommand.FONTMUL.MUL_1,
                LabelCommand.FONTMUL.MUL_1,"已检视");

        command.addText(360,952, LabelCommand.FONTTYPE.SIMPLIFIED_CHINESE, LabelCommand.ROTATION.ROTATION_0, LabelCommand.FONTMUL.MUL_1,
                LabelCommand.FONTMUL.MUL_1,"DD23 2860 9493 ");

        command.addText(360,992, LabelCommand.FONTTYPE.SIMPLIFIED_CHINESE, LabelCommand.ROTATION.ROTATION_0, LabelCommand.FONTMUL.MUL_1,
                LabelCommand.FONTMUL.MUL_1,"发件网点:760030");

        command.add1DBarcode(40,256, LabelCommand.BARCODETYPE.CODE128,104, LabelCommand.READABLE.DISABLE, LabelCommand.ROTATION.ROTATION_0,3,4,"DD2328609493");
//    [command add1DBarcode:40 :256 :@ "128" :104 :0 :0 :3 :4 :@ "DD2328609493"];
//    [command addPrint:1 :1];
        command.addPrint(1);
        DeviceConnFactoryManager.getDeviceConnFactoryManager().sendDataImmediately(command.getCommand());
//    [Manager.bleManager write:[command getCommand]];
    }

    /**
     * Disconnect
     */
    public void btnDisConn(View view) {
        if (!isConnected()) {
            Utils.toast(this, getString(R.string.str_cann_printer));
            return;
        }
        mHandler.obtainMessage(CONN_STATE_DISCONN).sendToTarget();
    }

    @Override
    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (resultCode == RESULT_OK) {
            switch (requestCode) {

                case Constant.BLUETOOTH_REQUEST_CODE: {
                    closeport();
                    //Get bluetoot mac address
                    String macAddress = data.getStringExtra(BluetoothDeviceList.EXTRA_DEVICE_ADDRESS);
                    //Init DeviceConnFactoryManager
                    new DeviceConnFactoryManager.Build()
                            .setConnectMethod(DeviceConnFactoryManager.CONN_METHOD.BLUETOOTH)
                            //Set bluetooth mac address
                            .setMacAddress(macAddress)
                            .build();
                    //Open port
                    threadPool = ThreadPool.getInstantiation();
                    threadPool.addTask(() -> DeviceConnFactoryManager.getDeviceConnFactoryManager().openPort());
                    break;
                }
                default:
                    break;
            }
        }
    }

    /**
     * Reconnection recycles the last connected object to avoid memory leakage
     */
    private void closeport() {
        if (isConnected()) {
//            DeviceConnFactoryManager.getDeviceConnFactoryManagers()[id].reader.cancel();
            DeviceConnFactoryManager.getDeviceConnFactoryManager().closePort();
        }
    }

    /**
     * Print label
     */
    void sendLabel() {
        LabelCommand tsc = new LabelCommand();
        // Set the label size according to the actual size
        tsc.addSize(60, 60);
        // Set the label gap according to the actual size. If it is no gap paper, set it to 0
        tsc.addGap(0);
        // Set print direction
        tsc.addDirection(LabelCommand.DIRECTION.BACKWARD, LabelCommand.MIRROR.NORMAL);
        // Turn on Printing with response for continuous printing
        tsc.addQueryPrinterStatus(LabelCommand.RESPONSE_MODE.ON);
        // Set origin coordinates
        tsc.addReference(0, 0);
        // Tearing mode on
        tsc.addTear(EscCommand.ENABLE.ON);
        // Clear print buffer
        tsc.addCls();
        // Draw simplified Chinese
        tsc.addText(10, 0, LabelCommand.FONTTYPE.SIMPLIFIED_CHINESE, LabelCommand.ROTATION.ROTATION_0, LabelCommand.FONTMUL.MUL_1, LabelCommand.FONTMUL.MUL_1,
                "Welcome to use SMARNET printer");
        // Draw a picture
        Bitmap b = BitmapFactory.decodeResource(getResources(), R.drawable.picture);
        tsc.addBitmap(10, 20, -1, 3.7f, LabelCommand.BITMAP_MODE.OVERWRITE, 300, b);

        tsc.addQRCode(10, 330, LabelCommand.EEC.LEVEL_L, 5, LabelCommand.ROTATION.ROTATION_0, "www.smarnet.cc");
        // Drawing one dimensional bar code
        tsc.add1DBarcode(10, 450, LabelCommand.BARCODETYPE.CODE128, 100,  LabelCommand.READABLE.ENABLE, LabelCommand.ROTATION.ROTATION_0, "SMARNET");
        // print label
        tsc.addPrint(1, 1);
        // Buzzer sounds after label printing
        tsc.addSound(2, 100);
        tsc.addCashdrwer(LabelCommand.FOOT.F5, 255, 255);
        Vector<Byte> datas = tsc.getCommand();
        // send data
        DeviceConnFactoryManager.getDeviceConnFactoryManager().sendDataImmediately(datas);
    }

    private BroadcastReceiver receiver = new BroadcastReceiver() {
        @Override
        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            switch (action) {
                case DeviceConnFactoryManager.ACTION_CONN_STATE:
                    int state = intent.getIntExtra(DeviceConnFactoryManager.STATE, -1);
                    int deviceId = intent.getIntExtra(DeviceConnFactoryManager.DEVICE_ID, -1);
                    switch (state) {
                        case DeviceConnFactoryManager.CONN_STATE_DISCONNECT:
                            if (id == deviceId) {
                                tvConnState.setText(getString(R.string.str_conn_state_disconnect));
                            }
                            break;
                        case DeviceConnFactoryManager.CONN_STATE_CONNECTING:
                            tvConnState.setText(getString(R.string.str_conn_state_connecting));
                            break;
                        case DeviceConnFactoryManager.CONN_STATE_CONNECTED:
                            tvConnState.setText(getString(R.string.str_conn_state_connected) + "\n" + getConnDeviceInfo());
                            break;
                        case CONN_STATE_FAILED:
                            Utils.toast(MainActivity.this, getString(R.string.str_conn_fail));
                            //wificonn=false;
                            tvConnState.setText(getString(R.string.str_conn_state_disconnect));
                            break;
                        default:
                            break;
                    }
                    break;
                case ACTION_QUERY_PRINTER_STATE:
                    if (counts >= 0) {
                        if (continuityprint) {
                            printcount++;
                            Utils.toast(MainActivity.this, getString(R.string.str_continuityprinter) + " " + printcount);
                        }
                        if (counts != 0) {
//                            sendContinuityPrint();
                        } else {
                            continuityprint = false;
                        }
                    }
                    break;
                default:
                    break;
            }
        }
    };

    private Handler mHandler = new Handler() {
        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case CONN_STATE_DISCONN:
                    if (isConnected()) {
                        DeviceConnFactoryManager.getDeviceConnFactoryManager().closePort();
                        Utils.toast(MainActivity.this, getString(R.string.str_disconnect_success));
                    }
                    break;
                case PRINTER_COMMAND_ERROR:
                    Utils.toast(MainActivity.this, getString(R.string.str_choice_printer_command));
                    break;
                case CONN_PRINTER:
                    Utils.toast(MainActivity.this, getString(R.string.str_cann_printer));
                    break;
            }
        }
    };

    @Override
    protected void onStop() {
        super.onStop();
        unregisterReceiver(receiver);
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        Log.e(TAG, "onDestroy()");
        if (isConnected()) {
            DeviceConnFactoryManager.getDeviceConnFactoryManager().closePort();
        }
        if (threadPool != null) {
            threadPool.stopThreadPool();
        }
    }

    private String getConnDeviceInfo() {
        String str = "";
        if (isConnected()) {
            if (DeviceConnFactoryManager.getDeviceConnFactoryManager().getConnMethod() == DeviceConnFactoryManager.CONN_METHOD.BLUETOOTH) {
                str += "BLUETOOTH\n";
                str += "MacAddress: " + DeviceConnFactoryManager.getDeviceConnFactoryManager().getMacAddress();
            } else if (DeviceConnFactoryManager.getDeviceConnFactoryManager().getConnMethod() == DeviceConnFactoryManager.CONN_METHOD.WIFI) {
                str += "WIFI\n";
                str += "IP: " + DeviceConnFactoryManager.getDeviceConnFactoryManager().getIp() + "\n";
                str += "Port: " + DeviceConnFactoryManager.getDeviceConnFactoryManager().getPort();
            }
        }
        return str;
    }

    private boolean isConnected() {
        return DeviceConnFactoryManager.getDeviceConnFactoryManager() != null && DeviceConnFactoryManager.getDeviceConnFactoryManager().getConnState();
    }

}